/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.exception.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.ThreadUtils;
import com.lubanops.apm.plugin.exception.common.stats.ExceptionConfig;
import org.slf4j.MDC;

public class LogbackEventInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            SpanEvent spanEvent = TraceCollector.getSpanEvent();
            if (spanEvent != null) {
                String traceId = spanEvent.getTraceId();
                String spanId = spanEvent.getSpanId();
                this.putMDC("apm-traceid", traceId);
                this.putMDC("apm-spanid", spanId);
                ThreadUtils.updateThreadName((String)traceId, (Boolean)ExceptionConfig.isLogPrintTrace());
            } else {
                this.removeMDC("apm-traceid");
                this.removeMDC("apm-spanid");
                ThreadUtils.resetThreadName();
            }
            String gtraceId = TraceCollector.getVirtualTraceId();
            if (gtraceId != null) {
                this.putMDC("apm-gtraceid", gtraceId);
            } else {
                this.removeMDC("apm-gtraceid");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private void putMDC(String key, String value) throws ClassNotFoundException {
        try {
            MDC.put((String)key, (String)value);
        }
        catch (Throwable e) {
            org.apache.log4j.MDC.put((String)key, (Object)value);
        }
    }

    private void removeMDC(String key) throws ClassNotFoundException {
        try {
            MDC.remove((String)key);
        }
        catch (Throwable e) {
            org.apache.log4j.MDC.remove((String)key);
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
    }
}

