/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.exception.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.ThreadUtils;
import com.lubanops.apm.plugin.exception.common.stats.ExceptionConfig;
import org.apache.log4j.MDC;

public class Log4jEventInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        SpanEvent traceSpanEvent = TraceCollector.getSpanEvent();
        if (traceSpanEvent != null) {
            String traceId = traceSpanEvent.getTraceId();
            String spanId = traceSpanEvent.getSpanId();
            MDC.put((String)"apm-traceid", (Object)traceId);
            MDC.put((String)"apm-spanid", (Object)spanId);
            ThreadUtils.updateThreadName((String)traceId, (Boolean)ExceptionConfig.isLogPrintTrace());
        } else {
            MDC.remove((String)"apm-traceid");
            MDC.remove((String)"apm-spanid");
            ThreadUtils.resetThreadName();
        }
        String traceGTraceId = TraceCollector.getVirtualTraceId();
        if (traceGTraceId != null) {
            MDC.put((String)"apm-gtraceid", (Object)traceGTraceId);
        } else {
            MDC.remove((String)"apm-gtraceid");
        }
        return null;
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }
}

