/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cse.interceptor;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.lubanops.apm.plugin.cse.interceptor.ConsumerHandler;
import com.lubanops.apm.plugin.cse.interceptor.EdgeHandler;
import com.lubanops.apm.plugin.cse.interceptor.Handler;
import com.lubanops.apm.plugin.cse.interceptor.ProviderHandler;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.event.InvocationBaseEvent;
import org.apache.servicecomb.core.event.InvocationBusinessMethodFinishEvent;
import org.apache.servicecomb.core.event.InvocationBusinessMethodStartEvent;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.InvocationStartEvent;

public class CSEListener
implements BootListener {
    public void onBootEvent(BootListener.BootEvent event) {
        if (BootListener.EventType.BEFORE_HANDLER.equals((Object)event.getEventType())) {
            SCBEngine.getInstance().getEventBus().register((Object)this);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onInvocationStart(InvocationStartEvent event) {
        this.getHandler((InvocationBaseEvent)event).onInvocationStart(event);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onInvocationFinish(InvocationFinishEvent event) {
        this.getHandler((InvocationBaseEvent)event).onInvocationFinish(event);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onInvocationBusinessStart(InvocationBusinessMethodStartEvent event) {
        this.getHandler((InvocationBaseEvent)event).onInvocationBusinessStart(event);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onInvocationBusinessFinish(InvocationBusinessMethodFinishEvent event) {
        this.getHandler((InvocationBaseEvent)event).onInvocationBusinessFinish(event);
    }

    private Handler getHandler(InvocationBaseEvent event) {
        boolean isConsumer = event.getInvocation().isConsumer();
        boolean isEdge = event.getInvocation().isEdge();
        if (isConsumer) {
            if (isEdge) {
                return new EdgeHandler();
            }
            return new ConsumerHandler();
        }
        return new ProviderHandler();
    }
}

