/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cse.collector.provider;

import com.lubanops.apm.bootstrap.collector.api.AbstractPrimaryKeyValueAggregator;
import com.lubanops.apm.bootstrap.collector.api.PrimaryKey;
import com.lubanops.apm.bootstrap.config.Stats;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlAggregator;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlSlowRequestThreshold;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStats;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.plugin.cse.collector.provider.config.CSEStatsConfig;
import com.lubanops.apm.plugin.cse.collector.provider.config.ExcludePattern;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CSEProviderDetailAggregator
extends UrlAggregator<UrlStats> {
    private static final Logger LOG = LogFactory.getLogger();
    private static String cse_tag_qualifiedName = "qualifiedName";
    private static String cse_tag_method = "method";
    private static String cse_tag_stats = "csestats";
    private static String cse_tag_start = "csestart";
    private static String cse_tag_pk = "csepk";
    private static String cse_tag_error = "cseerror";

    public String getName() {
        return "detail";
    }

    public String getUrlKey() {
        return cse_tag_qualifiedName;
    }

    protected int primaryKeyLength() {
        return 2;
    }

    protected List<String> primaryKey() {
        return Arrays.asList(cse_tag_qualifiedName, cse_tag_method);
    }

    protected Class<UrlStats> getValueType() {
        return UrlStats.class;
    }

    public void parseParameters(Map<String, String> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        Integer slowRequestThreshold = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"cseSlowRequestThreshold", Integer.class);
        this.setSlowRequestThreshold(slowRequestThreshold);
        Stats slowRequestTraceCountStats = (Stats)ParameterParseUtil.getParameterValue(parameters, (String)"cseSlowRequestTraceCountStats", Stats.class);
        this.setSlowRequestTraceCountStats(slowRequestTraceCountStats);
        Stats errorRequestTraceCounStats = (Stats)ParameterParseUtil.getParameterValue(parameters, (String)"cseErrorRequestTraceCounStats", Stats.class);
        this.setErrorRequestTraceCounStats(errorRequestTraceCounStats);
        Stats requestTranceCountStats = (Stats)ParameterParseUtil.getParameterValue(parameters, (String)"cseRequestTranceCountStats", Stats.class);
        this.setRequestTranceCountStats(requestTranceCountStats);
        String sampType = (String)ParameterParseUtil.getParameterValue(parameters, (String)"cseSampleType", String.class);
        String percentage = (String)ParameterParseUtil.getParameterValue(parameters, (String)"csePercentage", String.class);
        String periodCount = (String)ParameterParseUtil.getParameterValue(parameters, (String)"csePeriodCount", String.class);
        this.getSampleConfig().setPercentage(percentage);
        this.getSampleConfig().setPeriodCount(periodCount);
        this.getSampleConfig().setSampleType(sampType);
        Boolean bodyDetail = (Boolean)ParameterParseUtil.getParameterValue(parameters, (String)"cseBodyDetail", Boolean.class);
        CSEStatsConfig.setBodyDetail(bodyDetail);
        Integer bodyLength = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"cseBodyLength", Integer.class);
        CSEStatsConfig.setBodyLength(bodyLength);
        List excludeArray = (List)ParameterParseUtil.getParameterValue(parameters, (String)"cseExclude", List.class, ExcludePattern.class);
        CSEStatsConfig.setExcludeUrlList(excludeArray);
        List urlSlowRequestThresholds = (List)ParameterParseUtil.getParameterValue(parameters, (String)"cseurlSlowRequestThreshold", List.class, UrlSlowRequestThreshold.class);
        this.setUrlSlowRequestThresholds(urlSlowRequestThresholds);
        Integer bizCodeLength = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"cseBizCodeLength", Integer.class);
        CSEStatsConfig.setBizCodeLength(bizCodeLength);
        String[] bizCodeFields = (String[])ParameterParseUtil.getParameterValue(parameters, (String)"cseBizCodeFields", String[].class);
        CSEStatsConfig.setBizCodeFields(bizCodeFields);
        String[] bizCodeRightValues = (String[])ParameterParseUtil.getParameterValue(parameters, (String)"cseBizCodeRightValues", String[].class);
        CSEStatsConfig.setBizCodeRightValues(bizCodeRightValues);
        int[] range = (int[])ParameterParseUtil.getParameterValue(parameters, (String)"cseRange", int[].class);
        if (range != null && range.length == 5) {
            this.setRanges(range);
        } else {
            this.setRanges(AbstractPrimaryKeyValueAggregator.getDefaultRanges());
        }
    }

    public void onStart(String url, String method, String envId) {
        if (!this.isEnable) {
            return;
        }
        PrimaryKey pk = new PrimaryKey(new String[]{url, method});
        UrlStats stats = (UrlStats)this.getValue(pk);
        long start = stats.onStart();
        stats.setIsRoot(envId);
        Map map = this.getContextMap();
        map.put(cse_tag_stats, stats);
        map.put(cse_tag_start, start);
        map.put(cse_tag_pk, pk);
    }

    public long onFinally(int code, String nativeUrl, boolean hasError, boolean hasException) {
        if (!this.isEnable) {
            return 0L;
        }
        Map contextMap = this.getContextMap();
        if ("true".equals(this.getContextValue(contextMap, cse_tag_error))) {
            hasError = true;
        }
        UrlStats stat = (UrlStats)this.getContextValue(contextMap, cse_tag_stats);
        Long t = (Long)this.getContextValue(contextMap, cse_tag_start);
        long useTime = 0L;
        if (stat != null && t != null) {
            useTime = stat.onFinally(t.longValue(), nativeUrl, hasError, hasException);
        }
        if (code == 404) {
            PrimaryKey pk = (PrimaryKey)this.getContextValue(contextMap, cse_tag_pk);
            if (pk != null && null != stat && !stat.has200) {
                this.removeValue(pk);
            }
        } else if (null != stat) {
            stat.has200 = true;
        }
        contextMap.clear();
        return useTime;
    }

    public void onThrowable(Throwable th) {
        if (!this.isEnable) {
            return;
        }
        Map map = this.getContextMap();
        UrlStats stat = (UrlStats)this.getContextValue(map, cse_tag_stats);
        if (stat != null) {
            map.put(cse_tag_error, true);
        }
    }
}

