/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cse.collector.provider;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.url.StatusCodeStats;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlOverallAggregator;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStatusGroupAggregator;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.plugin.cse.collector.provider.CSEProviderClusterAggregator;
import com.lubanops.apm.plugin.cse.collector.provider.CSEProviderDetailAggregator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CSEProviderCollector
extends Collector {
    public static final CSEProviderCollector INSTANCE = new CSEProviderCollector();
    private static final CSEProviderDetailAggregator CSE_PROVIDER_DETAIL_AGGREGATOR = new CSEProviderDetailAggregator();
    private static final CSEProviderClusterAggregator CSE_PROVIDER_CLUSTER_AGGREGATOR = new CSEProviderClusterAggregator();
    private static final UrlOverallAggregator URL_OVERALL_AGGREGATOR = new UrlOverallAggregator();
    private static final UrlStatusGroupAggregator URL_STATUS_GROUP_AGGREGATOR = new UrlStatusGroupAggregator();
    private static int urlErrorCode = 400;
    private static Set<Integer> errorCodes = new HashSet<Integer>();
    private String[] headerKeys = new String[0];

    public static void onStart(String uri, String method, String envId) {
        if (uri == null) {
            return;
        }
        CSE_PROVIDER_DETAIL_AGGREGATOR.onStart(uri, method, envId);
        CSE_PROVIDER_CLUSTER_AGGREGATOR.onStart(envId);
    }

    public static void onThrowable(Throwable th) {
        CSE_PROVIDER_DETAIL_AGGREGATOR.onThrowable(th);
    }

    public static boolean onFinally(int code, String envId, String url, boolean hasException) {
        long t;
        boolean hasError = false;
        if (errorCodes.size() > 0) {
            if (errorCodes.contains(code)) {
                hasError = true;
            }
        } else if (code >= urlErrorCode) {
            hasError = true;
        }
        if ((t = CSE_PROVIDER_DETAIL_AGGREGATOR.onFinally(code, url, hasError, hasException)) > 0L && URL_OVERALL_AGGREGATOR.isEnable()) {
            CSE_PROVIDER_CLUSTER_AGGREGATOR.onFinally(envId, t, hasError);
            URL_OVERALL_AGGREGATOR.onTotal(t);
            if (hasError) {
                URL_OVERALL_AGGREGATOR.onError();
            }
            StatusCodeStats statusCodeStats = URL_STATUS_GROUP_AGGREGATOR.onCode(code);
            statusCodeStats.getCount().incrementAndGet();
            statusCodeStats.getUrl().set(url);
        }
        return hasError;
    }

    public static void clearThreadLocal() {
        CSE_PROVIDER_DETAIL_AGGREGATOR.clearThreadLocal();
    }

    public static Map<String, Object> getThreadLocalMap() {
        return CSE_PROVIDER_DETAIL_AGGREGATOR.getThreadLocalMap();
    }

    public static void setThreadLocalMap(Map<String, Object> map) {
        CSE_PROVIDER_DETAIL_AGGREGATOR.setThreadLocalMap(map);
    }

    public String getCollectorName() {
        return "CSEProvider";
    }

    public void parseParameter(Map<String, String> parameters) {
        if (parameters != null) {
            Integer urlErrorCode = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"urlErrorCode", Integer.class);
            CSEProviderCollector.urlErrorCode = urlErrorCode != null ? urlErrorCode : 400;
            String[] errorCodes = (String[])ParameterParseUtil.getParameterValue(parameters, (String)"errorCodes", String[].class);
            HashSet<Integer> errorCodeSet = new HashSet<Integer>();
            if (errorCodes != null) {
                for (String errorCode : errorCodes) {
                    errorCodeSet.add(Integer.valueOf(errorCode));
                }
            }
            CSEProviderCollector.errorCodes = errorCodeSet;
            String[] headerKeys = (String[])ParameterParseUtil.getParameterValue(parameters, (String)"cseheaderKeys", String[].class);
            this.setHeaderKeys(headerKeys);
        } else {
            urlErrorCode = 400;
            errorCodes = new HashSet<Integer>();
        }
    }

    public String[] getHeaderKeys() {
        return this.headerKeys;
    }

    public void setHeaderKeys(String[] headerKeys) {
        this.headerKeys = headerKeys != null ? headerKeys : new String[0];
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)CSE_PROVIDER_DETAIL_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)CSE_PROVIDER_CLUSTER_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)URL_OVERALL_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)URL_STATUS_GROUP_AGGREGATOR);
        INSTANCE.register();
    }
}

