/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.httpasyncclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.PoolObjectHolder;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.httpasyncclient.collector.ApacheHttpAsyncClientCollector;
import org.apache.http.conn.routing.HttpRoute;

public class PoolRequestConnectionInterceptor
implements Interceptor {
    private static final String POOL_ID = "PoolId";
    private static final String ROUTE = "Route";

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (ApacheHttpAsyncClientCollector.INSTANCE.isEnable()) {
                Integer poolId;
                Integer registeredPoolId = (Integer)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"poolId");
                if (registeredPoolId == null) {
                    poolId = PoolObjectHolder.acquireSequence();
                    TransformAccessUtils.saveToLopsAttributeMap((Object)object, (String)"poolId", (Object)poolId);
                    PoolObjectHolder.register((Object)object);
                } else {
                    poolId = registeredPoolId;
                }
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                if (spanEvent != null) {
                    String route = ((HttpRoute)args[0]).toString();
                    spanEvent.addTag(POOL_ID, String.valueOf(poolId));
                    spanEvent.addTag(ROUTE, route);
                }
            }
        }
        catch (Exception poolRequestException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)poolRequestException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
    }
}

