/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.httpasyncclient.collector;

import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.PoolObjectHolder;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;

public class NioConnectionPoolRouteAggregator
extends AbstractAggregator {
    public List<MonitorDataRow> harvest() {
        ArrayList<MonitorDataRow> nioResult = new ArrayList<MonitorDataRow>();
        CopyOnWriteArrayList poolList = PoolObjectHolder.getPoolList();
        for (Object o : poolList) {
            nioResult.addAll(this.buildRows(o));
        }
        return nioResult;
    }

    private List<MonitorDataRow> buildRows(Object obj) {
        Integer poolId;
        ArrayList<MonitorDataRow> list = new ArrayList<MonitorDataRow>();
        if (obj instanceof PoolingNHttpClientConnectionManager && obj instanceof TransformAccess && (poolId = (Integer)TransformAccessUtils.getFromLopsAttributeMap((Object)obj, (String)"poolId")) != null) {
            PoolingNHttpClientConnectionManager npm = (PoolingNHttpClientConnectionManager)obj;
            Set httpRoutes = npm.getRoutes();
            for (HttpRoute httpRoute : httpRoutes) {
                MonitorDataRow row = new MonitorDataRow();
                row.put((Object)"poolId", (Object)String.valueOf(poolId));
                row.put((Object)"route", (Object)httpRoute.toString());
                row.put((Object)"leased", (Object)npm.getStats(httpRoute).getLeased());
                row.put((Object)"pending", (Object)npm.getStats(httpRoute).getPending());
                row.put((Object)"available", (Object)npm.getStats(httpRoute).getAvailable());
                row.put((Object)"max", (Object)npm.getStats(httpRoute).getMax());
                list.add(row);
            }
        }
        return list;
    }

    public String getName() {
        return "connectionPoolRoute";
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        String nioPoolId = primaryKeyMap.get("poolId");
        String nioRoute = primaryKeyMap.get("route");
        if (nioPoolId == null || nioRoute == null) {
            return null;
        }
        CopyOnWriteArrayList nioPoolList = PoolObjectHolder.getPoolList();
        for (Object o : nioPoolList) {
            List<MonitorDataRow> rows = this.buildRows(o);
            for (MonitorDataRow row : rows) {
                if (!nioPoolId.equals(row.get((Object)"poolId")) || !nioRoute.equals(row.get((Object)"route"))) continue;
                return row;
            }
        }
        return null;
    }

    public List<MonitorDataRow> getAllStatus() {
        ArrayList<MonitorDataRow> nioResult = new ArrayList<MonitorDataRow>();
        CopyOnWriteArrayList poolList = PoolObjectHolder.getPoolList();
        for (Object o : poolList) {
            nioResult.addAll(this.buildRows(o));
        }
        return nioResult;
    }
}

