/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.paho.mqttv3.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mqtt.collector.PahoSubscriberCollector;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.paho.mqttv3.PahoV3SampleFilter;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;

public class DeliverMessageInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (PahoSubscriberCollector.INSTANCE.isEnable()) {
                ClientComms clientComms = (ClientComms)((AttributeAccess)object).getLopsFileds()[0];
                String serverUri = clientComms.getClient().getServerURI();
                String topicName = (String)args[0];
                String source = serverUri + "@" + topicName;
                StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, "", "", "");
                startTraceRequest.setKind("PahoSubscriber");
                startTraceRequest.setSourceEventId("");
                startTraceRequest.setDomainId("");
                startTraceRequest.setSource(source);
                startTraceRequest.setMethod(methodName);
                startTraceRequest.setSampleFilter((SampleFilter)new PahoV3SampleFilter());
                TraceCollector.onStart((StartTraceRequest)startTraceRequest);
                PahoSubscriberCollector.onDeliverMsgStart((String)source);
            }
        }
        catch (Exception deliverMessageException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)deliverMessageException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (PahoSubscriberCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
                PahoSubscriberCollector.onException((Throwable)e);
            }
        }
        catch (Exception deliverMessageException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)deliverMessageException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            SpanEvent spanEvent;
            if (PahoSubscriberCollector.INSTANCE.isEnable() && (spanEvent = TraceCollector.getSpanEvent()) != null) {
                boolean hasError = spanEvent.getHasError();
                int code = hasError ? 500 : 200;
                TraceCollector.onFinally((int)code, (boolean)hasError);
                PahoSubscriberCollector.onDeliverMsgFinally((String)spanEvent.getTraceId());
            }
        }
        catch (Exception deliverMessageException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)deliverMessageException);
        }
    }
}

