/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.postgresql.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.plugin.postgresql.collector.PgsqlCollector;
import org.postgresql.jdbc.PgConnection;

public class ConnectionCloseInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            Integer id;
            PgConnection connection;
            if (object instanceof TransformAccess && !(connection = (PgConnection)object).isClosed() && (id = (Integer)((TransformAccess)object).getLopsAttribute()) != null) {
                PgsqlCollector.onConnectionDestroyed(id);
            }
        }
        catch (Exception pgConnCloseException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)pgConnCloseException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable ex, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
    }
}

