/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.producer.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.plugin.rocketmq.common.stats.RocketMqInvokeStats;
import java.util.concurrent.atomic.AtomicLong;

public class RocketMqPublishStats
extends RocketMqInvokeStats {
    private volatile long publishedMsgCountOld;
    private volatile long publishedBytesOld;
    private final AtomicLong publishedMsgCount = new AtomicLong();
    private final AtomicLong publishedBytes = new AtomicLong();

    public void incrementPublishedMsgCount(int count) {
        this.publishedMsgCount.addAndGet(count);
    }

    public void incrementPublishedBytesCount(int count) {
        this.publishedBytes.addAndGet(count);
    }

    @Override
    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put((Object)"publishedMsgCount", (Object)this.publishedMsgCount.get());
        row.put((Object)"publishedBytes", (Object)this.publishedBytes.get());
        return row;
    }

    @Override
    public MonitorDataRow harvest(int[] newRanges) {
        long publishedMsgCountNew = this.publishedMsgCount.get();
        long publishedBytesNew = this.publishedBytes.get();
        MonitorDataRow row = super.harvest(newRanges);
        if (row != null) {
            row.put((Object)"publishedMsgCount", (Object)(publishedMsgCountNew - this.publishedMsgCountOld));
            row.put((Object)"publishedBytes", (Object)(publishedBytesNew - this.publishedBytesOld));
        }
        this.publishedMsgCountOld = publishedMsgCountNew;
        this.publishedBytesOld = publishedBytesNew;
        return row;
    }
}

