/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.producer.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.plugin.rocketmq.RocketMqContext;
import com.lubanops.apm.plugin.rocketmq.RocketMqUtils;
import com.lubanops.apm.plugin.rocketmq.producer.collector.RocketMqBasicPublishAggregator;
import com.lubanops.apm.plugin.rocketmq.producer.stats.RocketMqPublishStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RocketMqClientIdPublishAggregator
extends RocketMqBasicPublishAggregator {
    public void onStart(String clientId, String group) {
        if (!this.isEnable) {
            return;
        }
        RocketMqPublishStats stats = (RocketMqPublishStats)this.getValue(new String[]{clientId, group});
        stats.setClientId(clientId);
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
    }

    @Override
    public void onFinally() {
        if (!this.isEnable) {
            return;
        }
        RocketMqPublishStats stats = (RocketMqPublishStats)((Object)this.statsLocal.get());
        Long startTime = (Long)this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            String nameServer;
            long timeUsed = System.nanoTime() - startTime;
            Boolean hasError = (Boolean)this.errorLocal.get();
            if (hasError == null) {
                hasError = Boolean.FALSE;
            }
            if ((nameServer = RocketMqContext.NAMESERVER_LOCAL.get()) == null) {
                nameServer = "unknown";
            }
            TransactionCollector.collect((long)timeUsed, (boolean)hasError, (String)String.valueOf(IdentityConfigManager.getEnvId()), (String)("RocketMq:" + nameServer), (List)TransactionCollector.getTxName(), (String)"RocketMqProducer");
        }
        super.onFinally();
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
        ArrayList<MonitorDataRow> totalRowList = new ArrayList<MonitorDataRow>();
        long totalInvokeCount = 0L;
        long totalPublishedMsgCount = 0L;
        long totalPublishedBytes = 0L;
        long totalErrorCount = 0L;
        long totalTotalTime = 0L;
        if (collected != null && !collected.isEmpty()) {
            for (MonitorDataRow row : collected) {
                long invokeCount = RocketMqUtils.getLongValElseZero(row, "invokeCount");
                long publishedMsgCount = RocketMqUtils.getLongValElseZero(row, "publishedMsgCount");
                long publishedBytes = RocketMqUtils.getLongValElseZero(row, "publishedBytes");
                long errorCount = RocketMqUtils.getLongValElseZero(row, "errorCount");
                long totalTime = RocketMqUtils.getLongValElseZero(row, "totalTime");
                totalInvokeCount += invokeCount;
                totalPublishedMsgCount += publishedMsgCount;
                totalPublishedBytes += publishedBytes;
                totalErrorCount += errorCount;
                totalTotalTime += totalTime;
            }
        }
        MonitorDataRow totalRow = new MonitorDataRow();
        totalRow.put((Object)"invokeCount", (Object)totalInvokeCount);
        totalRow.put((Object)"publishedMsgCount", (Object)totalPublishedMsgCount);
        totalRow.put((Object)"publishedBytes", (Object)totalPublishedBytes);
        totalRow.put((Object)"errorCount", (Object)totalErrorCount);
        totalRow.put((Object)"totalTime", (Object)totalTotalTime);
        totalRowList.add(totalRow);
        res.put("total", totalRowList);
        return res;
    }

    protected int primaryKeyLength() {
        return 2;
    }

    @Override
    protected List<String> primaryKey() {
        return Arrays.asList("clientId", "group");
    }

    protected Class<RocketMqPublishStats> getValueType() {
        return RocketMqPublishStats.class;
    }

    @Override
    public String getName() {
        return "clientIdPublish";
    }
}

