/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.consumer.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.plugin.rocketmq.RocketMqContext;
import com.lubanops.apm.plugin.rocketmq.consumer.collector.RocketMqBasicPullAggregator;
import com.lubanops.apm.plugin.rocketmq.consumer.stats.RocketMqPullStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RocketMqClientIdPullAggregator
extends RocketMqBasicPullAggregator {
    public void onStart(String clientId, String group) {
        if (!this.isEnable) {
            return;
        }
        RocketMqPullStats stats = (RocketMqPullStats)this.getValue(new String[]{clientId, group});
        stats.setClientId(clientId);
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
    }

    public Map<String, Object> onStartAsync(String clientId, String group) {
        if (!this.isEnable) {
            return new HashMap<String, Object>();
        }
        RocketMqPullStats stats = (RocketMqPullStats)this.getValue(new String[]{clientId, group});
        stats.setClientId(clientId);
        long startTime = stats.onStart();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stats", (Object)stats);
        map.put("startTime", startTime);
        return map;
    }

    @Override
    public void onFinally() {
        if (!this.isEnable) {
            return;
        }
        RocketMqPullStats stats = (RocketMqPullStats)((Object)this.statsLocal.get());
        Long startTime = (Long)this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            String nameServer;
            long timeUsed = System.nanoTime() - startTime;
            Boolean hasError = (Boolean)this.errorLocal.get();
            if (hasError == null) {
                hasError = Boolean.FALSE;
            }
            if ((nameServer = RocketMqContext.NAMESERVER_LOCAL.get()) == null) {
                nameServer = "unknown";
            }
            TransactionCollector.collect((long)timeUsed, (boolean)hasError, (String)("RocketMq:" + nameServer), (String)String.valueOf(IdentityConfigManager.getEnvId()), (List)TransactionCollector.getTxName(), (String)"RocketMqConsumer");
        }
        super.onFinally();
    }

    @Override
    public void onFinallyAsync(Map<String, Object> map) {
        if (!this.isEnable) {
            return;
        }
        RocketMqPullStats stats = (RocketMqPullStats)((Object)map.get("stats"));
        Long startTime = (Long)map.get("startTime");
        if (stats != null && startTime != null) {
            String nameServer;
            long timeUsed = System.nanoTime() - startTime;
            Boolean hasError = (Boolean)map.get("hasError");
            if (!Boolean.TRUE.equals(hasError)) {
                hasError = false;
            }
            if ((nameServer = (String)map.get("nameServer")) == null) {
                nameServer = "unknown";
            }
            TransactionCollector.collect((long)timeUsed, (boolean)hasError, (String)("RocketMq:" + nameServer), (String)String.valueOf(IdentityConfigManager.getEnvId()), (List)TransactionCollector.getTxName(), (String)"RocketMqConsumer");
        }
        super.onFinallyAsync(map);
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
        ArrayList<MonitorDataRow> totalRowList = new ArrayList<MonitorDataRow>();
        long totalInvokeCount = 0L;
        long totalPulledMsgCount = 0L;
        long totalPulledBytes = 0L;
        long totalErrorCount = 0L;
        long totalTotalTime = 0L;
        if (collected != null && !collected.isEmpty()) {
            for (MonitorDataRow row : collected) {
                Long invokeCount = (Long)row.get((Object)"invokeCount");
                Long pulledMsgCount = (Long)row.get((Object)"pulledMsgCount");
                Long pulledBytes = (Long)row.get((Object)"pulledBytes");
                Long errorCount = (Long)row.get((Object)"errorCount");
                Long totalTime = (Long)row.get((Object)"totalTime");
                if (invokeCount == null) {
                    invokeCount = 0L;
                }
                if (pulledMsgCount == null) {
                    pulledMsgCount = 0L;
                }
                if (pulledBytes == null) {
                    pulledBytes = 0L;
                }
                if (errorCount == null) {
                    errorCount = 0L;
                }
                if (totalTime == null) {
                    totalTime = 0L;
                }
                totalInvokeCount += invokeCount.longValue();
                totalPulledMsgCount += pulledMsgCount.longValue();
                totalPulledBytes += pulledBytes.longValue();
                totalErrorCount += errorCount.longValue();
                totalTotalTime += totalTime.longValue();
            }
        }
        MonitorDataRow totalRow = new MonitorDataRow();
        totalRow.put((Object)"pullInvokeCount", (Object)totalInvokeCount);
        totalRow.put((Object)"pulledMsgCount", (Object)totalPulledMsgCount);
        totalRow.put((Object)"pulledBytes", (Object)totalPulledBytes);
        totalRow.put((Object)"pullErrorCount", (Object)totalErrorCount);
        totalRow.put((Object)"pullTotalTime", (Object)totalTotalTime);
        totalRowList.add(totalRow);
        res.put("total", totalRowList);
        return res;
    }

    protected int primaryKeyLength() {
        return 2;
    }

    @Override
    protected List<String> primaryKey() {
        return Arrays.asList("clientId", "group");
    }

    protected Class<RocketMqPullStats> getValueType() {
        return RocketMqPullStats.class;
    }

    @Override
    public String getName() {
        return "clientIdPull";
    }
}

