/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RocketMqPidMapper {
    private static final ConcurrentHashMap<String, Set<String>> map = new ConcurrentHashMap();
    private static final int CLIENT_ID_LIMIT = 20;
    private static final int PID_LIMIT = 20;

    public static void register(String reformatClientId, String pid) {
        if (map.size() >= 20) {
            return;
        }
        if (map.containsKey(reformatClientId)) {
            Set<String> set = map.get(reformatClientId);
            if (set.size() < 20) {
                set.add(pid);
            }
        } else {
            Set<String> set = Collections.synchronizedSet(new HashSet());
            set.add(pid);
            map.put(reformatClientId, set);
        }
    }

    public static void unregister(String reformatClientId, String pid) {
        Set<String> set = map.get(reformatClientId);
        if (set != null) {
            set.remove(pid);
        }
    }

    public static String getPid(String reformatClientId) {
        if (reformatClientId == null) {
            return null;
        }
        Set<String> set = map.get(reformatClientId);
        if (set == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String pid : set) {
            if (sb.length() == 0) {
                sb.append(pid);
                continue;
            }
            sb.append(",").append(pid);
        }
        return sb.toString();
    }
}

