/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq;

import com.lubanops.apm.bootstrap.AttributeAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.client.impl.consumer.ConsumeMessageService;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.apache.rocketmq.client.impl.consumer.MQConsumerInner;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;

public class RocketMqClientHolder {
    private static final int SIZE_LIMIT = 20;
    private static final Set<MQClientInstance> clientSet = Collections.synchronizedSet(new HashSet());

    public static void registerClientObject(MQClientInstance client) {
        if (clientSet.size() < 20) {
            clientSet.add(client);
        }
    }

    public static void unregisterClientObject(MQClientInstance client) {
        clientSet.remove(client);
    }

    public static List<ConsumeMessageService> getAllConsumeMessageServices() {
        ArrayList<ConsumeMessageService> list = new ArrayList<ConsumeMessageService>();
        for (MQClientInstance clientInstance : clientSet) {
            Object[] attributes = ((AttributeAccess)clientInstance).getLopsFileds();
            ConcurrentHashMap consumerTable = (ConcurrentHashMap)attributes[1];
            for (MQConsumerInner consumerInner : consumerTable.values()) {
                if (!(consumerInner instanceof DefaultMQPushConsumerImpl)) continue;
                ConsumeMessageService consumeMessageService = (ConsumeMessageService)((AttributeAccess)consumerInner).getLopsFileds()[4];
                list.add(consumeMessageService);
            }
        }
        return list;
    }
}

