/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.websocket.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.websocket.collector.WebsocketCollector;
import com.lubanops.apm.plugin.websocket.interceptor.Utils;
import com.lubanops.apm.plugin.websocket.interceptor.WSSampleFilter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.server.WsFrameServer;

public class SendMessageInterceptor
implements Interceptor {
    private static ThreadLocal<Boolean> hasError = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        if (WebsocketCollector.INSTANCE.isEnable() && object instanceof AttributeAccess) {
            long traffic = 0L;
            AttributeAccess attributeAccess = (AttributeAccess)object;
            Object[] fields = attributeAccess.getLopsFileds();
            WsSession session = (WsSession)fields[0];
            if (session != null) {
                CharBuffer charBuffer = (CharBuffer)fields[1];
                if ("sendMessageText".equals(methodName)) {
                    traffic = charBuffer.remaining();
                } else if ("sendMessageBinary".equals(methodName)) {
                    ByteBuffer byteBuffer = (ByteBuffer)args[0];
                    traffic = byteBuffer.remaining();
                }
                String url = session.getRequestURI().toString();
                String restUrl = Utils.getRestUrl(session);
                WebsocketCollector.onStart(restUrl, traffic);
                StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, null, null, null);
                startTraceRequest.setRealSource(url);
                startTraceRequest.setSource(restUrl);
                startTraceRequest.setKind("Websocket");
                startTraceRequest.setSampleFilter((SampleFilter)new WSSampleFilter());
                TraceCollector.onStart((StartTraceRequest)startTraceRequest);
                TraceCollector.addTag((String)"traffic", (String)String.valueOf(traffic));
            }
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (WebsocketCollector.INSTANCE.isEnable() && object instanceof AttributeAccess) {
            AttributeAccess attributeAccess = (AttributeAccess)object;
            Object[] fields = attributeAccess.getLopsFileds();
            WsSession session = (WsSession)fields[0];
            WebsocketCollector.exception(e);
            if (session != null) {
                WebsocketCollector.onError(Utils.getRestUrl(session));
                TraceCollector.onError((Throwable)e);
                hasError.set(true);
            }
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        AttributeAccess attributeAccess;
        Object[] fields;
        WsSession session;
        if (WebsocketCollector.INSTANCE.isEnable() && object instanceof AttributeAccess && object instanceof WsFrameServer && (session = (WsSession)(fields = (attributeAccess = (AttributeAccess)object).getLopsFileds())[0]) != null) {
            WebsocketCollector.onFinally(Utils.getRestUrl(session));
            int code = 200;
            Boolean isError = hasError.get();
            if (isError != null && isError.booleanValue()) {
                code = 500;
            }
            TraceCollector.onFinally((int)code);
            hasError.set(null);
        }
    }
}

