/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.clickhouse.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.plugin.clickhouse.ClickHouseContext;
import java.util.List;
import ru.yandex.clickhouse.BalancedClickhouseDataSource;

public class BalancedGetConnectionInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            BalancedClickhouseDataSource dataSource = (BalancedClickhouseDataSource)object;
            String allUrls = this.convertUrlListToString(dataSource.getAllClickhouseUrls());
            ClickHouseContext.clusterUrlsLocal.set(allUrls);
        }
        catch (Exception getConnException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)getConnException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable ex, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            ClickHouseContext.clusterUrlsLocal.remove();
        }
        catch (Exception getConnException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)getConnException);
        }
    }

    private String convertUrlListToString(List<String> urls) {
        StringBuilder sb = new StringBuilder();
        for (String url : urls) {
            String trimmedUrl = this.trimmedUrl(url);
            if (sb.length() == 0) {
                sb.append(trimmedUrl);
                continue;
            }
            sb.append(",").append(trimmedUrl);
        }
        return "ClickHouse:" + sb.toString();
    }

    private String trimmedUrl(String url) {
        int suffixIndex;
        int prefixIndex = url.indexOf("jdbc:clickhouse://");
        if (prefixIndex != -1) {
            url = url.substring(prefixIndex + 18);
        }
        if ((suffixIndex = url.indexOf("?")) != -1) {
            url = url.substring(0, suffixIndex);
        }
        return url;
    }
}

