/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.url.collector;

import com.lubanops.apm.bootstrap.plugin.url.collector.UrlStatsCollector;
import com.lubanops.apm.bootstrap.plugin.url.collector.config.ExcludePattern;
import com.lubanops.apm.bootstrap.plugin.url.collector.config.UrlPattern;
import com.lubanops.apm.bootstrap.plugin.url.collector.config.UrlStatsConfig;
import com.lubanops.apm.bootstrap.utils.AntPathMatcher;
import java.util.List;
import java.util.Set;

public class UrlAnalysisUtils {
    private static AntPathMatcher matcher = new AntPathMatcher();

    public static String getTargetUrl(String realUrl, String pathInfo, String contextPath) {
        return UrlAnalysisUtils.getTargetUrl(realUrl, pathInfo, contextPath, null);
    }

    public static String getTargetUrl(String realUrl, String pathInfo, String contextPath, String host) {
        String result = null;
        List<ExcludePattern> excludeUrlList = UrlStatsConfig.getExcludeUrlList();
        for (ExcludePattern excludePattern : excludeUrlList) {
            if (!excludePattern.isExcludeUrl(realUrl)) continue;
            return null;
        }
        List<UrlPattern> urlPatternList = UrlStatsConfig.getUrlList();
        for (UrlPattern urlPattern : urlPatternList) {
            result = urlPattern.getTargetUrl(realUrl);
            if (result == null) continue;
            return result;
        }
        if (UrlStatsCollector.getAutoNormalize()) {
            return realUrl;
        }
        Set<String> set = UrlStatsConfig.getSpringUrlList();
        if (set == null || set.size() == 0) {
            if (realUrl != null) {
                result = realUrl;
            } else if (pathInfo != null) {
                result = pathInfo;
            }
        } else {
            result = UrlAnalysisUtils.matchSpringUrl(set, realUrl, pathInfo, contextPath);
            if (result == null && host != null) {
                return UrlStatsConfig.getCf2Router().get(host);
            }
        }
        return result;
    }

    private static String matchSpringUrl(Set<String> springUrlList, String uri, String pathInfo, String contextPath) {
        String urlPath = null;
        if (uri != null) {
            if (contextPath != null && uri.startsWith(contextPath)) {
                uri = uri.substring(contextPath.length());
            }
        } else {
            return null;
        }
        urlPath = uri;
        if (pathInfo == null) {
            pathInfo = urlPath;
        }
        if (pathInfo.endsWith("/") && pathInfo.length() > 1) {
            pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
        }
        for (String springurl : springUrlList) {
            if (!matcher.match(springurl, pathInfo) && !matcher.match(springurl, urlPath)) continue;
            return springurl;
        }
        return null;
    }
}

