/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.tomcat.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.NonePrimaryKeyAggregator;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class TomcatInfoAggregator
extends NonePrimaryKeyAggregator {
    private static final int RETRY_TIME = 8;
    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private AtomicInteger failCount = new AtomicInteger(0);
    private MonitorDataRow r = new MonitorDataRow();
    private volatile boolean obtainSuccess = false;

    public String getName() {
        return "tomcatInfo";
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public MonitorDataRow constructItemRow() {
        if (this.obtainSuccess) {
            return this.r;
        }
        if (this.failCount.get() >= 8) {
            return null;
        }
        this.obtainVersion();
        return this.r;
    }

    public boolean obtainVersion() {
        if (this.obtainSuccess || this.failCount.get() >= 8) {
            return this.obtainSuccess;
        }
        try {
            Object obj;
            ObjectName objName = new ObjectName("Catalina:type=Server");
            Set<ObjectName> nn = this.server.queryNames(objName, null);
            if (nn == null || nn.isEmpty()) {
                objName = new ObjectName("Tomcat:type=Server");
            }
            if (null != (obj = this.server.getAttribute(objName, "serverInfo"))) {
                String serverVersion = obj.toString();
                this.r.put((Object)"tomcatVersion", (Object)serverVersion);
                this.obtainSuccess = true;
            }
        }
        catch (Throwable e) {
            this.failCount.incrementAndGet();
        }
        return this.obtainSuccess;
    }

    public void clear() {
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public List<MonitorDataRow> getAllStatus() {
        return null;
    }
}

