/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.collector.provider;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.plugin.dubbo.collector.DubboClusterAggregator;
import com.lubanops.apm.plugin.dubbo.collector.DubboInvocationAggregator;
import com.lubanops.apm.plugin.dubbo.collector.DubboResultCodeAggregator;
import com.lubanops.apm.plugin.dubbo.collector.DubboThreadPoolAggregator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

public class DubboProviderCollector
extends Collector {
    public static final DubboProviderCollector INSTANCE = new DubboProviderCollector();
    private static final int INVOCATION_LENGTH_DEFAULT = 500;
    private static final int ATTACHMENT_LENGTH_DEFAULT = 500;
    private static DubboInvocationAggregator invocationAggregator = new DubboInvocationAggregator();
    private static DubboClusterAggregator clusterAggregator = new DubboClusterAggregator();
    private static DubboResultCodeAggregator resultCodeAggregator = new DubboResultCodeAggregator();
    private static DubboThreadPoolAggregator threadPoolAggregator = new DubboThreadPoolAggregator();
    private static DefaultVersionAggregator versionAggregator = new DefaultVersionAggregator();
    private boolean invocationDetail = Boolean.FALSE;
    private int invocationLength = 500;
    private boolean attachmentDetail = Boolean.FALSE;
    private int attachmentLength = 500;
    private List<String> attachmentKeys = new ArrayList<String>();
    private List<String> fieldFilterList = new ArrayList<String>(Arrays.asList("passwd", "password", "username", "user", "card", "cardno", "cvv"));

    public static void onStart(String serviceUniqueName, String method) {
        invocationAggregator.onStart(serviceUniqueName, method);
    }

    public static void onResponse(long startTime, String traceId, String serviceUniqueName, String method, String clusterId, boolean success) {
        invocationAggregator.onResponse(startTime, traceId, serviceUniqueName, method);
        clusterAggregator.onComplete(startTime, clusterId);
        if (success) {
            resultCodeAggregator.onFinally(method, "success");
        }
    }

    public static void onError(Throwable th, long startTime, String traceId, String serviceUniqueName, String method, String clusterId) {
        invocationAggregator.onError(th, startTime, traceId, serviceUniqueName, method);
        clusterAggregator.onError(th, startTime, clusterId);
        resultCodeAggregator.onFinally(method, "fail");
    }

    public static DubboProviderCollector getInstance() {
        return INSTANCE;
    }

    public void setVersion(String version) {
        versionAggregator.setVersion(version);
    }

    public void onThreadPoolCreated(String poolId, ThreadPoolExecutor pool, String poolType) {
        threadPoolAggregator.register(poolId, pool, poolType);
    }

    public void parseParameter(Map<String, String> parameters) {
        Boolean invocationDetail = (Boolean)ParameterParseUtil.getParameterValue(parameters, (String)"invocationDetail", Boolean.class);
        this.setInvocationDetail(invocationDetail);
        Integer invocationLength = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"invocationLength", Integer.class);
        this.setInvocationLength(invocationLength);
        Boolean attachmentDetail = (Boolean)ParameterParseUtil.getParameterValue(parameters, (String)"attachmentDetail", Boolean.class);
        this.setAttachmentDetail(attachmentDetail);
        Integer attachmentLength = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"attachmentLength", Integer.class);
        this.setAttachmentLength(attachmentLength);
        String[] attachmentKeys = (String[])ParameterParseUtil.getParameterValue(parameters, (String)"attachmentKeys", String[].class);
        this.setAttachmentKeys(attachmentKeys);
        String[] filterKeys = (String[])ParameterParseUtil.getParameterValue(parameters, (String)"fieldFilterKeys", String[].class);
        this.setFieldFilterKeys(filterKeys);
    }

    public String getCollectorName() {
        return "DubboProvider";
    }

    private void setFieldFilterKeys(String[] filterKeys) {
        if (null != filterKeys && filterKeys.length > 0) {
            for (String key : filterKeys) {
                this.fieldFilterList.add(key);
            }
        }
    }

    public boolean isInvocationDetail() {
        return this.invocationDetail;
    }

    private void setInvocationDetail(Boolean invocationDetail) {
        if (invocationDetail == null) {
            this.invocationDetail = false;
            return;
        }
        this.invocationDetail = invocationDetail;
    }

    public int getInvocationLength() {
        return this.invocationLength;
    }

    private void setInvocationLength(Integer invocationLength) {
        if (invocationLength == null) {
            this.invocationLength = 500;
            return;
        }
        this.invocationLength = invocationLength;
    }

    public boolean isAttachmentDetail() {
        return this.attachmentDetail;
    }

    private void setAttachmentDetail(Boolean attachmentDetail) {
        if (attachmentDetail == null) {
            this.attachmentDetail = false;
            return;
        }
        this.attachmentDetail = attachmentDetail;
    }

    public int getAttachmentLength() {
        return this.attachmentLength;
    }

    private void setAttachmentLength(Integer attachmentLength) {
        if (attachmentLength == null) {
            this.attachmentLength = 500;
            return;
        }
        this.attachmentLength = attachmentLength;
    }

    public List<String> getAttachmentKeys() {
        return this.attachmentKeys;
    }

    private void setAttachmentKeys(String[] attachments) {
        if (null != attachments && attachments.length > 0) {
            for (String key : attachments) {
                this.attachmentKeys.add(key);
            }
        }
    }

    public List<String> getFieldFilterList() {
        return this.fieldFilterList;
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)invocationAggregator);
        INSTANCE.addModelAggregator((MetricSetAggregator)clusterAggregator);
        INSTANCE.addModelAggregator((MetricSetAggregator)resultCodeAggregator);
        INSTANCE.addModelAggregator((MetricSetAggregator)threadPoolAggregator);
        INSTANCE.addModelAggregator((MetricSetAggregator)versionAggregator);
        INSTANCE.register();
    }
}

