/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.StatsBase;
import java.lang.ref.WeakReference;
import java.util.concurrent.ThreadPoolExecutor;

public class DubboThreadPoolStats
implements StatsBase {
    private static final String DEFAULT_THREADPOOL_TYPE = "fixed";
    private static final String FIELD_ACTIVE_COUNT = "activeCount";
    private static final String FIELD_CORE_POOL_SIZE = "corePoolSize";
    private static final String FIELD_MAXIMUM_POOL_SIZE = "maximumPoolSize";
    private static final String FIELD_POOL_SIZE = "poolSize";
    private static final String FIELD_QUEUE_SIZE = "queueSize";
    private static final String FIELD_TASK_COUNT = "taskCount";
    private static final String FIELD_POOL_TYPE = "poolType";
    private WeakReference<ThreadPoolExecutor> poolRef = new WeakReference<Object>(null);
    private String threadPoolType = "fixed";

    void bind(ThreadPoolExecutor pool, String poolType) {
        this.poolRef = new WeakReference<ThreadPoolExecutor>(pool);
        this.threadPoolType = poolType;
    }

    public MonitorDataRow getStatus() {
        return this.harvest();
    }

    public MonitorDataRow harvest() {
        MonitorDataRow dataRow = new MonitorDataRow();
        ThreadPoolExecutor pool = (ThreadPoolExecutor)this.poolRef.get();
        if (null != pool) {
            dataRow.put((Object)FIELD_POOL_TYPE, (Object)this.threadPoolType);
            dataRow.put((Object)FIELD_ACTIVE_COUNT, (Object)pool.getActiveCount());
            dataRow.put((Object)FIELD_CORE_POOL_SIZE, (Object)pool.getCorePoolSize());
            dataRow.put((Object)FIELD_MAXIMUM_POOL_SIZE, (Object)pool.getMaximumPoolSize());
            dataRow.put((Object)FIELD_POOL_SIZE, (Object)pool.getPoolSize());
            dataRow.put((Object)FIELD_QUEUE_SIZE, (Object)pool.getQueue().size());
            dataRow.put((Object)FIELD_TASK_COUNT, (Object)pool.getTaskCount());
        }
        return dataRow;
    }
}

