/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.exception.ApmRuntimeException;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.dubbo.collector.DubboClusterStats;
import java.util.List;
import java.util.Map;

public class DubboClusterAggregator
extends SinglePrimaryKeyAggregator<DubboClusterStats> {
    private static final String MODEL_NAME_CLUSTER = "cluster";
    private static final String DUBBO_AGGREGATE_KEY_CLUSTER = "cluster";
    private static final String DEFAULT_CLUSTER_ID = "user";
    private static final String DEFAULT_CLUSTER_NAME = "user";
    private static ThreadLocal<DubboClusterStats> statsLocal = new ThreadLocal();
    private static ThreadLocal<Long> timeLocal = new ThreadLocal();
    private static ThreadLocal<String> pkLocal = new ThreadLocal();

    protected String primaryKey() {
        return "cluster";
    }

    protected Class<DubboClusterStats> getValueType() {
        return DubboClusterStats.class;
    }

    protected String defaultKey() {
        return "default_key_sys";
    }

    public void parseParameters(Map<String, String> parameters) {
        for (DubboClusterStats stats : this.valueStats.values()) {
            stats.parseRange(parameters);
        }
    }

    public String getName() {
        return "cluster";
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public void onError(Throwable th, long startTime, String clusterId) {
        DubboClusterStats stat;
        if (StringUtils.isBlank((String)clusterId)) {
            clusterId = "user";
        }
        if ((stat = (DubboClusterStats)this.getValue(clusterId)) != null && startTime > 0L) {
            stat.onThrowable(th);
        }
    }

    public void onComplete(long startTime, String clusterId) {
        DubboClusterStats stat;
        if (!this.isEnable) {
            return;
        }
        if (StringUtils.isBlank((String)clusterId)) {
            clusterId = "user";
        }
        if ((stat = (DubboClusterStats)this.getValue(clusterId)) != null && startTime > 0L) {
            stat.onFinally(System.nanoTime() - startTime);
        }
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        MonitorDataRow result = null;
        String cluster = primaryKeyMap.get("cluster");
        if (cluster == null) {
            throw new ApmRuntimeException("get status by primary key,but cluster is null");
        }
        DubboClusterStats consumerClusterStats = (DubboClusterStats)this.getValue(cluster);
        if (null != consumerClusterStats) {
            result = consumerClusterStats.getStatus();
            result.put((Object)"cluster", (Object)cluster);
        }
        return result;
    }
}

