/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.collector.api.FutureStatsAccessor;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.Tags;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.dubbo.collector.consumer.DubboConsumerCollector;
import com.lubanops.apm.plugin.dubbo.collector.provider.DubboProviderCollector;
import com.lubanops.apm.plugin.dubbo.utils.InterceptorAssist;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;

public class MonitorFilterOnErrorInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        Throwable error = (Throwable)args[0];
        Invoker invoker = (Invoker)args[1];
        Invocation invocation = (Invocation)args[2];
        if (InterceptorAssist.isEnable(invoker) && invocation instanceof TransformAccess) {
            String apmRemoteEnvId;
            TransformAccess transformAccess = (TransformAccess)invocation;
            FutureStatsAccessor futureStatsAccessor = (FutureStatsAccessor)transformAccess.getLopsAttribute();
            SpanEvent spanEvent = futureStatsAccessor.getSpanEvent();
            String apmTraceId = "";
            if (spanEvent != null) {
                apmTraceId = spanEvent.getTraceId();
            }
            String string = apmRemoteEnvId = "consumer".equals(invoker.getUrl().getParameter("side")) ? invoker.getUrl().getParameter(Headers.ENV_ID.getValue()) : invocation.getAttachment(Headers.ENV_ID.getValue());
            if ("consumer".equals(invoker.getUrl().getParameter("side"))) {
                DubboConsumerCollector.onError(error, futureStatsAccessor.getStartTime(), apmTraceId, futureStatsAccessor.getServiceName(), futureStatsAccessor.getMethod(), apmRemoteEnvId);
                DubboConsumerCollector.onResponse(futureStatsAccessor.getStartTime(), apmTraceId, futureStatsAccessor.getServiceName(), futureStatsAccessor.getMethod(), apmRemoteEnvId, false);
            } else {
                DubboProviderCollector.onError(error, futureStatsAccessor.getStartTime(), apmTraceId, futureStatsAccessor.getServiceName(), futureStatsAccessor.getMethod(), futureStatsAccessor.getEnvId());
                DubboProviderCollector.onResponse(futureStatsAccessor.getStartTime(), apmTraceId, futureStatsAccessor.getServiceName(), futureStatsAccessor.getMethod(), apmRemoteEnvId, false);
            }
            if (spanEvent != null) {
                spanEvent.setAsync(true);
                spanEvent.setHasError(Boolean.TRUE.booleanValue());
                long timeUsed = System.currentTimeMillis() - spanEvent.getStartTime();
                spanEvent.setTimeUsed(timeUsed);
                spanEvent.setCode(500);
                spanEvent.addTag(Tags.asyncTimeUsed.name(), String.valueOf(timeUsed));
                TraceCollector.onError((SpanEvent)spanEvent, (Throwable)error);
                TraceCollector.sendSpanEvent((SpanEvent)spanEvent);
            }
        }
    }
}

