/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.api.APIService;
import com.lubanops.apm.bootstrap.collector.api.FutureStatsAccessor;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.dubbo.collector.common.TransformAccessRequest;
import com.lubanops.apm.plugin.dubbo.collector.constant.DubboTags;
import com.lubanops.apm.plugin.dubbo.collector.consumer.DubboConsumerCollector;
import com.lubanops.apm.plugin.dubbo.collector.filter.DubboProviderSampleFilter;
import com.lubanops.apm.plugin.dubbo.collector.provider.DubboProviderCollector;
import com.lubanops.apm.plugin.dubbo.collector.utils.DubboCollectorUtil;
import com.lubanops.apm.plugin.dubbo.utils.InterceptorAssist;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.support.RpcUtils;

public class MonitorFilterInvokeInterceptor
implements Interceptor {
    public static final String CONSUMER_TAG = "DUBBO_CONSUMER";
    public static final String PROVIDER_TAG = "DUBBO_PROVIDER";
    public static final String HIDE_CODE = "***";

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        Invoker invoker = (Invoker)args[0];
        Invocation invocation = (Invocation)args[1];
        if (InterceptorAssist.isEnable(invoker)) {
            String side = invoker.getUrl().getParameter("side");
            String interfaceName = invoker.getInterface().getName();
            String group = invoker.getUrl().getParameter("group");
            String version = invoker.getUrl().getParameter("version");
            String serviceUniqueName = DubboCollectorUtil.buildServiceKey(interfaceName, group, version);
            String method = RpcUtils.getMethodName((Invocation)invocation);
            String protocol = invoker.getUrl().getProtocol();
            String application = invoker.getUrl().getParameter("application");
            String apmServiceType = "consumer".equals(invoker.getUrl().getParameter("side")) ? CONSUMER_TAG : PROVIDER_TAG;
            SpanEvent apmSpanEvent = null;
            String source = DubboCollectorUtil.buildSourceKey(serviceUniqueName, method);
            apmSpanEvent = "consumer".equals(invoker.getUrl().getParameter("side")) ? this.processConsumer(className, methodName, invocation, serviceUniqueName, method, apmServiceType, source) : this.processProvider(className, methodName, invocation, serviceUniqueName, method, apmServiceType, source);
            this.transformAccess(invoker, invocation, new TransformAccessRequest(side, serviceUniqueName, method, protocol, application, apmSpanEvent));
        }
        return null;
    }

    private void transformAccess(Invoker invoker, Invocation invocation, TransformAccessRequest transformAccessRequest) {
        TransformAccess transformAccess = (TransformAccess)invocation;
        FutureStatsAccessor statsAccessor = new FutureStatsAccessor();
        transformAccess.setLopsAttribute((Object)statsAccessor);
        statsAccessor.setServiceName(transformAccessRequest.getServiceUniqueName());
        statsAccessor.setMethod(transformAccessRequest.getMethod());
        statsAccessor.setStartTime(System.nanoTime());
        if (transformAccessRequest.getApmSpanEvent() != null) {
            transformAccessRequest.getApmSpanEvent().addTag("serviceUniqueName", transformAccessRequest.getServiceUniqueName());
            transformAccessRequest.getApmSpanEvent().addTag("method", transformAccessRequest.getMethod());
            transformAccessRequest.getApmSpanEvent().addTag("side", transformAccessRequest.getSide());
            transformAccessRequest.getApmSpanEvent().addTag("protocol", transformAccessRequest.getProtocol());
            transformAccessRequest.getApmSpanEvent().addTag("application", transformAccessRequest.getApplication());
            if (RpcUtils.isAsync((URL)invoker.getUrl(), (Invocation)invocation)) {
                transformAccessRequest.getApmSpanEvent().setAsync(true);
            } else {
                transformAccessRequest.getApmSpanEvent().setAsync(false);
            }
            if (RpcUtils.isOneway((URL)invoker.getUrl(), (Invocation)invocation)) {
                transformAccessRequest.getApmSpanEvent().addTag("oneway", "true");
            } else {
                transformAccessRequest.getApmSpanEvent().addTag("oneway", "false");
            }
            statsAccessor.setSpanEvent(transformAccessRequest.getApmSpanEvent());
        }
    }

    private SpanEvent processProvider(String className, String methodName, Invocation invocation, String serviceUniqueName, String method, String apmServiceType, String source) {
        String apmDomainId = invocation.getAttachment(Headers.DOMAIN_ID.getValue());
        String apmDomainType = invocation.getAttachment(Headers.DOMAIN_TYPE.getValue());
        String apmTraceId = invocation.getAttachment(Headers.TRACE_ID.getValue());
        String apmSpanId = invocation.getAttachment(Headers.SPAN_ID.getValue());
        String apmEnvId = invocation.getAttachment(Headers.ENV_ID.getValue());
        String apmGTraceId = null;
        if (StringUtils.isBlank((String)apmTraceId)) {
            apmGTraceId = invocation.getAttachment(Headers.GTRACE_ID.getValue());
        }
        String userFlag = invocation.getAttachment(Headers.USER_FLAG.getValue());
        DubboProviderCollector.onStart(serviceUniqueName, method);
        StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, apmTraceId, apmSpanId, apmGTraceId);
        startTraceRequest.setKind(apmServiceType);
        startTraceRequest.setSource(source);
        startTraceRequest.setRealSource(source);
        startTraceRequest.setSourceEventId(apmEnvId);
        startTraceRequest.setDomainId(apmDomainId);
        startTraceRequest.setDomainType(apmDomainType);
        startTraceRequest.setSampleFilter((SampleFilter)new DubboProviderSampleFilter());
        SpanEvent apmSpanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
        TraceCollector.USER_FLAG_THREAD_LOCAL.set(userFlag);
        if (apmSpanEvent != null) {
            apmSpanEvent.addTag("url", source);
        }
        return apmSpanEvent;
    }

    private SpanEvent processConsumer(String className, String methodName, Invocation invocation, String serviceUniqueName, String method, String apmServiceType, String source) {
        String userFlag;
        String apmVTraceId;
        DubboConsumerCollector.onStart(serviceUniqueName, method);
        SpanEvent apmSpanEvent = TraceCollector.getSpanEvent();
        if (apmSpanEvent != null) {
            apmSpanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)apmServiceType);
        }
        invocation.getAttachments().put(Headers.ENV_ID.getValue(), String.valueOf(IdentityConfigManager.getEnvId()));
        invocation.getAttachments().put(Headers.DOMAIN_ID.getValue(), String.valueOf(IdentityConfigManager.getDomainId()));
        invocation.getAttachments().put(Headers.DOMAIN_TYPE.getValue(), String.valueOf(IdentityConfigManager.getDomainType()));
        if (apmSpanEvent != null) {
            invocation.getAttachments().put(Headers.TRACE_ID.getValue(), apmSpanEvent.getTraceId());
            invocation.getAttachments().put(Headers.SPAN_ID.getValue(), apmSpanEvent.generateNextSpanId());
            apmSpanEvent.addTag("url", source);
        }
        if ((apmVTraceId = TraceCollector.getVirtualTraceId()) != null) {
            invocation.setAttachment(Headers.GTRACE_ID.getValue(), apmVTraceId);
        }
        if ((userFlag = TraceCollector.getUserFlag()) != null) {
            invocation.setAttachment(Headers.USER_FLAG.getValue(), userFlag);
        }
        return apmSpanEvent;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        Invoker invoker = (Invoker)args[0];
        Invocation invocation = (Invocation)args[1];
        if (InterceptorAssist.isEnable(invoker)) {
            SpanEvent spanEvent = TraceCollector.getSpanEvent();
            if ("provider".equals(invoker.getUrl().getParameter("side"))) {
                if (spanEvent != null) {
                    String apmArguments;
                    if (DubboProviderCollector.getInstance().isInvocationDetail() && (apmArguments = APIService.getJsonApi().toJSONString((Object)invocation.getArguments(), DubboProviderCollector.getInstance().getFieldFilterList())) != null && apmArguments.length() > 0) {
                        spanEvent.addTag(DubboTags.arguments.name(), apmArguments, DubboProviderCollector.getInstance().getInvocationLength());
                    }
                    if (DubboProviderCollector.getInstance().isAttachmentDetail()) {
                        Map<String, String> attachmentsMap = this.filterAttachments(invocation.getAttachments());
                        String apmAttachments = APIService.getJsonApi().toJSONString(attachmentsMap, DubboProviderCollector.getInstance().getFieldFilterList());
                        if (apmAttachments != null && apmAttachments.length() > 0) {
                            spanEvent.addTag(DubboTags.attachments.name(), apmAttachments, DubboProviderCollector.getInstance().getAttachmentLength());
                        }
                    }
                }
                TraceCollector.onRootFinallyNoSend();
            } else {
                TraceCollector.onFinally((boolean)false);
            }
            if (spanEvent != null) {
                TransformAccess transformAccess = (TransformAccess)invocation;
                FutureStatsAccessor futureStatsAccessor = (FutureStatsAccessor)transformAccess.getLopsAttribute();
                futureStatsAccessor.setSpanEvent(spanEvent);
            }
        }
    }

    private Map<String, String> filterAttachments(Map<String, String> attachmentsMap) {
        HashMap<String, String> newAttachments = new HashMap<String, String>();
        for (String key : attachmentsMap.keySet()) {
            if (!DubboProviderCollector.getInstance().getAttachmentKeys().contains(key)) continue;
            newAttachments.put(key, HIDE_CODE);
        }
        return newAttachments;
    }
}

