/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.collector.utils;

public class DubboCollectorUtil {
    public static String parseGroup(String serviceUniqueName) {
        int groupEndTagIndex = serviceUniqueName.indexOf("/");
        return groupEndTagIndex != -1 ? serviceUniqueName.substring(0, groupEndTagIndex) : "";
    }

    public static String parseService(String serviceUniqueName) {
        int startIndex = 0;
        int endIndex = serviceUniqueName.length();
        if (serviceUniqueName.indexOf("/") != -1) {
            startIndex = serviceUniqueName.indexOf("/") + 1;
        }
        if (serviceUniqueName.indexOf(":") != -1) {
            endIndex = serviceUniqueName.indexOf(":");
        }
        return serviceUniqueName.substring(startIndex, endIndex);
    }

    public static String parserVersion(String serviceUniqueName) {
        int versionStartTagIndex = serviceUniqueName.indexOf(":");
        return versionStartTagIndex != -1 ? serviceUniqueName.substring(versionStartTagIndex + 1, serviceUniqueName.length()) : "";
    }

    public static String buildServiceKey(String path, String group, String version) {
        StringBuilder buf = new StringBuilder();
        if (group != null && group.length() > 0) {
            buf.append(group).append("/");
        }
        buf.append(path);
        if (version != null && version.length() > 0) {
            buf.append(":").append(version);
        }
        return buf.toString();
    }

    public static String buildSourceKey(String serviceUniqueName, String method) {
        StringBuilder buf = new StringBuilder();
        if (serviceUniqueName != null && serviceUniqueName.length() > 0 && method != null && method.length() > 0) {
            return buf.append(serviceUniqueName).append("/").append(method).toString();
        }
        throw new IllegalArgumentException(String.format("[APM COLLECTOR]build sourceKey fail,serviceUniqueName[%s],method[%s]", serviceUniqueName, method));
    }
}

