/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.access.trace;

import com.lubanops.apm.integration.access.inbound.EventDataBody;
import com.lubanops.apm.integration.access.inbound.EventDataHeader;
import com.lubanops.apm.integration.access.trace.SpanInfo;
import java.util.Map;

public class SpanInfoBuilder {
    public static SpanInfo build(EventDataHeader header, EventDataBody body) {
        SpanInfo spanInfo = new SpanInfo();
        spanInfo.setInstanceId(header.getInstanceId());
        spanInfo.setAppId(header.getAppId());
        spanInfo.setBizId(header.getBizId());
        spanInfo.setEnvId(header.getEnvId());
        spanInfo.setDomainId(header.getDomainId());
        spanInfo.setStartTime(body.getStartTime());
        spanInfo.setTimeUsed(body.getTimeUsed());
        Map<String, Object> tags = body.getTags();
        spanInfo.setTags(tags);
        if (tags != null && tags.get("httpMethod") != null) {
            spanInfo.setMethod(String.valueOf(tags.get("httpMethod")));
        }
        if (tags != null && tags.get("bizCode") != null) {
            spanInfo.setBizCode(String.valueOf(tags.get("bizCode")));
        }
        spanInfo.setAsync(body.isAsync());
        spanInfo.setClassName(body.getClassName());
        spanInfo.setStatusCode(body.getCode());
        spanInfo.setGlobalTraceId(body.getGlobalTraceId());
        spanInfo.setGlobalPath(body.getGlobalPath());
        spanInfo.setTraceId(body.getTraceId());
        spanInfo.setSpanId(body.getSpanId());
        spanInfo.setHasError(body.getHasError());
        spanInfo.setErrorReasons(body.getErrorReasons());
        spanInfo.setResource(body.getSource());
        spanInfo.setRealSource(body.getRealSource());
        return spanInfo;
    }
}

