/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.access.trace;

import com.lubanops.apm.integration.utils.TimeUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MonitorItemRow {
    private long time;
    private Map<String, Object> entries = new HashMap<String, Object>();

    public MonitorItemRow() {
    }

    public MonitorItemRow(long t) {
        this.time = t;
    }

    public MonitorItemRow(long t, Map<String, Object> entries) {
        this.time = t;
        this.entries = entries;
    }

    public MonitorItemRow makeCopyOfAndRemoveFields(Set<String> trimedFields) {
        MonitorItemRow newItem = new MonitorItemRow();
        newItem.setTime(this.time);
        HashMap<String, Object> newEntries = new HashMap<String, Object>();
        newEntries.putAll(this.entries);
        if (trimedFields != null && !trimedFields.isEmpty()) {
            for (String s : trimedFields) {
                newEntries.remove(s);
            }
        }
        newItem.setEntries(newEntries);
        return newItem;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(time:").append(TimeUtil.getDefaultInstance().formatWithDefault(this.time));
        sb.append(",data entries:[");
        if (this.entries != null) {
            Set<Map.Entry<String, Object>> enset = this.entries.entrySet();
            for (Map.Entry<String, Object> entry : enset) {
                sb.append(entry.getKey()).append("=");
                Object v = entry.getValue();
                if (v == null) {
                    sb.append(",");
                    continue;
                }
                sb.append(v.toString()).append(",");
            }
        }
        sb.append("]");
        sb.append(")");
        return sb.toString();
    }

    public Object getValue(String key) {
        return this.entries.get(key);
    }

    public void put(String key, Object value) {
        this.entries.put(key, value);
    }

    public void putAll(Map<String, Object> all) {
        this.entries.putAll(all);
    }

    public Map<String, Object> getEntries() {
        return this.entries;
    }

    public void setEntries(Map<String, Object> entries) {
        this.entries = entries;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long collectDate) {
        this.time = collectDate;
    }
}

