/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.access.outbound;

import com.lubanops.apm.integration.access.Header;
import com.lubanops.apm.integration.access.MessageIdGenerator;
import com.lubanops.apm.integration.access.MessageWrapper;
import com.lubanops.apm.integration.utils.JSON;

public class SessionOpenRequest
extends MessageWrapper {
    private long messageId = MessageIdGenerator.generateMessageId();
    private SessionOpenHeader header;

    public SessionOpenRequest() {
    }

    public SessionOpenRequest(String code, String msg, Long instanceId) {
        SessionOpenHeader header;
        this.header = header = new SessionOpenHeader(code, msg, instanceId);
    }

    public SessionOpenHeader getHeader() {
        return this.header;
    }

    public void setHeader(SessionOpenHeader header) {
        this.header = header;
    }

    @Override
    public short getType() {
        return 5;
    }

    @Override
    public long getMessageId() {
        return this.messageId;
    }

    @Override
    public byte[] getHeaderBytes() {
        return this.header.toBytes();
    }

    @Override
    public String getHeadString() {
        return JSON.toJSONString(this.header);
    }

    @Override
    public String generateBodyString() {
        return "";
    }

    @Override
    public String getBodyString() {
        throw new UnsupportedOperationException(SessionOpenRequest.class.getSimpleName() + ".getBodyString() has no implementation.");
    }

    public static class SessionOpenHeader
    extends Header {
        public static String ok = "0";
        public static String error = "1";
        private String code = "0";
        private String msg;
        private String instanceId;

        public SessionOpenHeader() {
        }

        public SessionOpenHeader(String code, String msg, Long instanceId) {
            this.code = code;
            this.msg = msg;
            this.instanceId = instanceId.toString();
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}

