/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.access;

import com.lubanops.apm.integration.Constants;
import com.lubanops.apm.integration.access.Message;

public abstract class MessageWrapper {
    private byte[] bodyBytes = null;
    private String bodyString = null;

    public Message generatorMessage() {
        Message message = new Message();
        message.setType(this.getType());
        message.setMessageId(this.getMessageId());
        message.setHeader(this.getHeaderBytes());
        message.setBody(this.getBodyBytes());
        return message;
    }

    public byte[] getBodyBytes() {
        if (null == this.bodyBytes) {
            this.bodyBytes = this.getBodyString().getBytes(Constants.DEFAULT_CHARSET);
        }
        return this.bodyBytes;
    }

    public String getBodyString() {
        if (null == this.bodyString || this.bodyString.length() == 0) {
            this.bodyString = this.generateBodyString();
        }
        return this.bodyString;
    }

    public abstract short getType();

    public abstract long getMessageId();

    public abstract byte[] getHeaderBytes();

    protected abstract String getHeadString();

    public abstract String generateBodyString();
}

