/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dbcp.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.connectionpool.ConnectionPoolUtils;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.dbcp.collector.DbcpCollector;

public class TimeSpanInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (DbcpCollector.INSTANCE.isEnable()) {
                TraceCollector.onStart((String)className, (String)methodName, (String)"DBCP");
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "TimeSpanInterceptor onStart", (Throwable)e1);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (DbcpCollector.INSTANCE.isEnable()) {
                ConnectionPoolUtils.setErrorMsg((Throwable)e);
            }
        }
        catch (Exception e5) {
            LogFactory.getLogger().log(Level.SEVERE, "TimeSpanInterceptor onError", (Throwable)e5);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            SpanEvent spanEvent;
            if (DbcpCollector.INSTANCE.isEnable() && (spanEvent = TraceCollector.onFinally((boolean)false)) != null && (spanEvent.getChildrenEventCount() > 0 || spanEvent.getTimeUsed() >= (long)DbcpCollector.INSTANCE.getTimeSpanThreshold() || spanEvent.getHasError())) {
                if (methodName.equals("create")) {
                    String msg = result != null ? "Successful" : "Failed";
                    spanEvent.addTag("Status", msg);
                }
                TraceCollector.sendSpanEvent((SpanEvent)spanEvent);
            }
        }
        catch (Exception e5) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e5);
        }
    }
}

