/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jetcd.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.jetcd.JetcdUtils;
import com.lubanops.apm.plugin.jetcd.collector.JetcdCollector;
import com.lubanops.apm.plugin.jetcd.interceptor.RequestProcessHelper;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.api.LeaderRequest;
import io.etcd.jetcd.options.WatchOption;

public class NonUnaryOnTraceInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            SpanEvent spanEvent;
            if (JetcdCollector.INSTANCE.isEnable() && (spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"Jetcd")) != null) {
                if (args.length == 1 && args[0] instanceof LeaderRequest) {
                    RequestProcessHelper.parseAndProcessElectionRequest(args[0], spanEvent);
                } else if (args.length == 3 && args[0] instanceof ByteSequence && args[1] instanceof WatchOption) {
                    spanEvent.addTag("watchCreateRequest", JetcdUtils.getWatchCreateRequestAsTag((ByteSequence)args[0], (WatchOption)args[1]));
                } else if (object instanceof Watch.Watcher && methodName.equals("close")) {
                    Long id = (Long)((AttributeAccess)object).getLopsFileds()[3];
                    spanEvent.addTag("watchCancelRequest", JetcdUtils.getWatchCancelRequestAsTag(id));
                }
            }
        }
        catch (Exception nonUnaryOnTraceException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)nonUnaryOnTraceException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                TraceCollector.onFinally();
            }
        }
        catch (Exception nonUnaryOnTraceException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)nonUnaryOnTraceException);
        }
    }
}

