/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jetcd.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.jetcd.JetcdContext;
import com.lubanops.apm.plugin.jetcd.JetcdServiceType;
import com.lubanops.apm.plugin.jetcd.collector.JetcdCollector;
import java.util.Map;

public class ClientOuterExecutionInterceptor
implements Interceptor {
    private static final String METHOD_NAME = "execute";

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)METHOD_NAME, (String)"Jetcd");
                if (args[1] instanceof TransformAccess) {
                    TransformAccessUtils.saveToLopsAttributeMap((Object)args[1], (String)"spanEvent", (Object)spanEvent);
                }
            }
        }
        catch (Exception clientOuterExecutionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)clientOuterExecutionException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                if (args[1] instanceof TransformAccess) {
                    JetcdServiceType requestType = JetcdContext.SERVICE_TYPE_LOCAL.get();
                    Map<String, Object> collectorContext = JetcdContext.COLLECTOR_CONTEXT_LOCAL.get();
                    TransformAccessUtils.saveToLopsAttributeMap((Object)args[1], (String)"serviceType", (Object)((Object)requestType));
                    TransformAccessUtils.saveToLopsAttributeMap((Object)args[1], (String)"collectorContext", collectorContext);
                }
                TraceCollector.onFinally((boolean)false);
                JetcdContext.SERVICE_TYPE_LOCAL.remove();
                JetcdContext.COLLECTOR_CONTEXT_LOCAL.remove();
            }
        }
        catch (Exception clientOuterExecutionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)clientOuterExecutionException);
        }
    }
}

