/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jetcd.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.jetcd.JetcdServiceType;
import com.lubanops.apm.plugin.jetcd.collector.JetcdCollector;
import com.lubanops.apm.plugin.jetcd.interceptor.ResponseProcessHelper;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ClientInnerExecutionInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable() && args.length >= 3 && args[0] instanceof CompletableFuture && args[2] instanceof TransformAccess) {
                CompletableFuture completableFuture = (CompletableFuture)args[0];
                SpanEvent spanEvent = (SpanEvent)TransformAccessUtils.getFromLopsAttributeMap((Object)args[2], (String)"spanEvent");
                JetcdServiceType serviceType = (JetcdServiceType)((Object)TransformAccessUtils.getFromLopsAttributeMap((Object)args[2], (String)"serviceType"));
                Map collectorContext = (Map)TransformAccessUtils.getFromLopsAttributeMap((Object)args[2], (String)"collectorContext");
                if (completableFuture.isCompletedExceptionally()) {
                    try {
                        completableFuture.getNow(null);
                    }
                    catch (Exception executionException) {
                        JetcdCollector.onException(executionException);
                        JetcdCollector.onRequestErrorAsync(collectorContext, spanEvent == null ? null : spanEvent.getTraceId());
                        TraceCollector.onError((SpanEvent)spanEvent, (Throwable)executionException);
                    }
                } else if (completableFuture.isDone()) {
                    Object response = completableFuture.getNow(null);
                    ResponseProcessHelper.parseAndProcessRequest(response, spanEvent, serviceType);
                }
                JetcdCollector.onRequestFinallyAsync(collectorContext, spanEvent == null ? null : spanEvent.getTraceId());
                if (spanEvent != null) {
                    TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
                }
            }
        }
        catch (Exception clientInnerExecutionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)clientInnerExecutionException);
        }
    }
}

