/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.producer.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.utils.ConcurrentUtil;
import com.lubanops.apm.plugin.rabbitmq.apreload.RabbitMqInvokeStats;
import java.util.concurrent.atomic.AtomicLong;

public class RabbitMqPublishInvokeStats
extends RabbitMqInvokeStats {
    private volatile long publishedMsgCountOld;
    private volatile long publishedBytesOld;
    private final AtomicLong publishedMsgCount = new AtomicLong();
    private final AtomicLong publishedBytes = new AtomicLong();
    private final AtomicLong maxSingleMsgBytes = new AtomicLong();

    public void incrementPublishedMsgCount() {
        this.publishedMsgCount.incrementAndGet();
    }

    public void incrementPublishedBytesCount(int count) {
        this.publishedBytes.addAndGet(count);
    }

    public void setMaxSingleMsgBytes(int msgBytes) {
        ConcurrentUtil.setMaxValue((AtomicLong)this.maxSingleMsgBytes, (long)msgBytes);
    }

    @Override
    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put((Object)"publishedMsgCount", (Object)this.publishedMsgCount.get());
        row.put((Object)"publishedBytes", (Object)this.publishedBytes.get());
        row.put((Object)"maxSingleMsgBytes", (Object)this.maxSingleMsgBytes.get());
        return row;
    }

    @Override
    public MonitorDataRow harvest(int[] newRanges) {
        long publishedMsgCountNew = this.publishedMsgCount.get();
        long publishedBytesNew = this.publishedBytes.get();
        MonitorDataRow row = super.harvest(newRanges);
        if (row != null) {
            row.put((Object)"publishedMsgCount", (Object)(publishedMsgCountNew - this.publishedMsgCountOld));
            row.put((Object)"publishedBytes", (Object)(publishedBytesNew - this.publishedBytesOld));
            row.put((Object)"maxSingleMsgBytes", (Object)this.maxSingleMsgBytes.get());
        }
        this.publishedMsgCountOld = publishedMsgCountNew;
        this.publishedBytesOld = publishedBytesNew;
        return row;
    }
}

