/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.consumer.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.rabbitmq.consumer.collector.RabbitMqConsumerCollector;
import com.rabbitmq.client.impl.ChannelN;

public class BasicRejectInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            RabbitMqConsumerCollector.initTag();
            if (RabbitMqConsumerCollector.INSTANCE.isEnable()) {
                ChannelN channelN = (ChannelN)object;
                String connection = channelN.getConnection().toString();
                String channelNum = String.valueOf(channelN.getChannelNumber());
                boolean requeue = (Boolean)args[1];
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"RabbitMqConsumer");
                if (spanEvent != null) {
                    spanEvent.addTag("connection", connection);
                    spanEvent.addTag("channelNum", channelNum);
                    spanEvent.addTag("requeue", String.valueOf(requeue));
                }
            }
        }
        catch (Exception rabbitMqRejectException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqRejectException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (RabbitMqConsumerCollector.INSTANCE.isEnable()) {
                RabbitMqConsumerCollector.onException(e);
                TraceCollector.onError((Throwable)e);
                this.hasErrorLocal.set(Boolean.TRUE);
            }
        }
        catch (Exception rabbitMqRejectException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqRejectException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (RabbitMqConsumerCollector.INSTANCE.isEnable()) {
                boolean hasError = false;
                if (Boolean.TRUE.equals(this.hasErrorLocal.get())) {
                    hasError = true;
                }
                ChannelN channelN = (ChannelN)object;
                long deliveryTag = (Long)args[0];
                boolean requeue = (Boolean)args[1];
                if (!hasError) {
                    int[] onRejectResult = RabbitMqConsumerCollector.onReject(channelN, deliveryTag, false, requeue);
                    SpanEvent spanEvent = TraceCollector.getSpanEvent();
                    if (spanEvent != null) {
                        spanEvent.addTag("rejectedMsgCount", String.valueOf(onRejectResult[0]));
                        spanEvent.addTag("requeuedMsgCount", String.valueOf(onRejectResult[1]));
                    }
                }
                TraceCollector.onFinally();
                this.hasErrorLocal.remove();
            }
        }
        catch (Exception rabbitMqRejectException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqRejectException);
        }
    }
}

