/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.consumer.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.rabbitmq.RabbitMqUtils;
import com.lubanops.apm.plugin.rabbitmq.consumer.collector.RabbitMqConsumerCollector;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ChannelN;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BasicGetInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            RabbitMqConsumerCollector.initTag();
            if (RabbitMqConsumerCollector.INSTANCE.isEnable()) {
                String queue = (String)args[0];
                ChannelN channelN = (ChannelN)object;
                AMQConnection connection = channelN.getConnection();
                String channelNum = String.valueOf(channelN.getChannelNumber());
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"RabbitMqConsumer");
                boolean autoAck = (Boolean)args[1];
                RabbitMqConsumerCollector.onConsumeStart(connection);
                if (spanEvent != null) {
                    spanEvent.addTag("connection", connection.toString());
                    spanEvent.addTag("channelNum", channelNum);
                    spanEvent.addTag("queue", queue);
                    spanEvent.addTag("autoAck", String.valueOf(autoAck));
                }
            }
        }
        catch (Exception rabbitMqGetException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqGetException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (RabbitMqConsumerCollector.INSTANCE.isEnable()) {
                RabbitMqConsumerCollector.onException(e);
                RabbitMqConsumerCollector.onError(TraceCollector.getTraceId(), false);
                TraceCollector.onError((Throwable)e);
                this.hasErrorLocal.set(Boolean.TRUE);
            }
        }
        catch (Exception rabbitMqGetException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqGetException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (RabbitMqConsumerCollector.INSTANCE.isEnable()) {
                boolean hasError = false;
                if (Boolean.TRUE.equals(this.hasErrorLocal.get())) {
                    hasError = true;
                }
                int bytesCount = 0;
                GetResponse response = (GetResponse)result;
                if (response != null) {
                    if (!hasError) {
                        bytesCount = response.getBody().length;
                        boolean autoAck = (Boolean)args[1];
                        if (!autoAck) {
                            ChannelN channel = (ChannelN)object;
                            Set<Long> unackedTags = (Set<Long>)TransformAccessUtils.getFromLopsAttributeMap((Object)channel, (String)"unackedMessageDeliveryTags");
                            if (unackedTags == null) {
                                unackedTags = Collections.synchronizedSet(new HashSet());
                                TransformAccessUtils.saveToLopsAttributeMap((Object)object, (String)"unackedMessageDeliveryTags", unackedTags);
                            }
                            if (unackedTags.size() < 3000) {
                                unackedTags.add(response.getEnvelope().getDeliveryTag());
                            } else {
                                LogFactory.getLogger().log(Level.WARNING, "size of unackedTags reaches RabbitMqConfig.MAX_CACHED_UNACK_TAGS_PER_CHANNEL.");
                            }
                        }
                    }
                    SpanEvent spanEvent = TraceCollector.getSpanEvent();
                    AMQP.BasicProperties properties = response.getProps();
                    if (spanEvent != null) {
                        RabbitMqUtils.addLubanOpsAttr(spanEvent, properties);
                    }
                }
                RabbitMqConsumerCollector.onConsumeFinally(bytesCount, hasError);
                TraceCollector.onFinally();
                this.hasErrorLocal.remove();
            }
        }
        catch (Exception rabbitMqGetException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqGetException);
        }
    }
}

