/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.consumer.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.rabbitmq.consumer.collector.RabbitMqConsumerCollector;
import com.rabbitmq.client.impl.ChannelN;

public class BasicAckInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            RabbitMqConsumerCollector.initTag();
            if (RabbitMqConsumerCollector.INSTANCE.isEnable()) {
                TraceCollector.onStart((String)className, (String)methodName, (String)"RabbitMqConsumer");
            }
        }
        catch (Exception rabbitMqAckException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqAckException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (RabbitMqConsumerCollector.INSTANCE.isEnable()) {
                RabbitMqConsumerCollector.onException(e);
                TraceCollector.onError((Throwable)e);
                this.hasErrorLocal.set(Boolean.TRUE);
            }
        }
        catch (Exception rabbitMqAckException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqAckException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (RabbitMqConsumerCollector.INSTANCE.isEnable()) {
                boolean hasError = false;
                if (Boolean.TRUE.equals(this.hasErrorLocal.get())) {
                    hasError = true;
                }
                ChannelN channel = (ChannelN)object;
                String connection = channel.getConnection().toString();
                String channelNum = String.valueOf(channel.getChannelNumber());
                long deliveryTag = (Long)args[0];
                boolean multiple = (Boolean)args[1];
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                if (spanEvent != null) {
                    spanEvent.addTag("connection", connection);
                    spanEvent.addTag("channelNum", channelNum);
                    spanEvent.addTag("multiple", String.valueOf(multiple));
                }
                if (!hasError) {
                    int ackedMsgCount = RabbitMqConsumerCollector.onAck(channel, deliveryTag, multiple);
                    if (spanEvent != null) {
                        spanEvent.addTag("ackedMsgCount", String.valueOf(ackedMsgCount));
                    }
                }
                TraceCollector.onFinally();
                this.hasErrorLocal.remove();
            }
        }
        catch (Exception rabbitMqAckException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqAckException);
        }
    }
}

