/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.common.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.rabbitmq.RabbitConnectionCounter;
import com.lubanops.apm.plugin.rabbitmq.RabbitConnectionHolder;
import com.lubanops.apm.plugin.rabbitmq.common.collector.RabbitMqCommonCollector;
import com.rabbitmq.client.impl.AMQConnection;

public class ConnectionShutdownInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            Boolean isStarted = (Boolean)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"isStarted");
            if (Boolean.TRUE.equals(isStarted)) {
                TransformAccessUtils.getFromAndRemoveLopsAttributeMap((Object)object, (String)"isStarted");
                AMQConnection connection = (AMQConnection)object;
                String connectionStr = connection.toString();
                RabbitConnectionCounter.decrementConnectionCount(connectionStr);
                RabbitMqCommonCollector.onConnectionClose(connectionStr);
                RabbitMqCommonCollector.onException((Throwable)args[0]);
                RabbitConnectionHolder.unregisterConnection(connection);
            }
        }
        catch (Exception rabbitConnectionCloseOkException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitConnectionCloseOkException);
        }
    }
}

