/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.common.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.rabbitmq.RabbitChannelHolder;
import com.lubanops.apm.plugin.rabbitmq.RabbitConnectionCounter;
import com.lubanops.apm.plugin.rabbitmq.common.collector.RabbitMqCommonCollector;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.impl.ChannelN;

public class ChannelShutdownInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            Boolean isStarted = (Boolean)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"isStarted");
            if (Boolean.TRUE.equals(isStarted)) {
                TransformAccessUtils.getFromAndRemoveLopsAttributeMap((Object)object, (String)"isStarted");
                Connection connection = ((Channel)object).getConnection();
                String connectionStr = connection.toString();
                RabbitConnectionCounter.decrementChannelCount(connectionStr);
                RabbitMqCommonCollector.onChannelClose(connectionStr);
                RabbitChannelHolder.unregisterChannel((ChannelN)object);
            }
        }
        catch (Exception rabbitChannelCloseOkException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitChannelCloseOkException);
        }
    }
}

