/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.common.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.plugin.rabbitmq.RabbitMqUtils;
import com.lubanops.apm.plugin.rabbitmq.apreload.RabbitMqInvokeStats;
import com.rabbitmq.client.impl.AMQConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RabbitMqConnectionInvokeAggregator<T extends RabbitMqInvokeStats>
extends SinglePrimaryKeyAggregator<T> {
    protected final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    protected final ThreadLocal<T> statsLocal = new ThreadLocal();
    private final ThreadLocal<Boolean> errorLocal = new ThreadLocal();

    public void onStart(AMQConnection connection) {
        if (!this.isEnable) {
            return;
        }
        String connectionAsString = connection.toString();
        RabbitMqInvokeStats stats = (RabbitMqInvokeStats)this.getValue(connectionAsString);
        stats.setConnection(connectionAsString);
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
    }

    public void onError(String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqInvokeStats stats = (RabbitMqInvokeStats)((Object)this.statsLocal.get());
        if (stats != null) {
            stats.onError(errorTraceId);
            this.errorLocal.set(Boolean.TRUE);
        }
    }

    public void onFinally() {
        if (!this.isEnable) {
            return;
        }
        RabbitMqInvokeStats stats = (RabbitMqInvokeStats)((Object)this.statsLocal.get());
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            Boolean hasError;
            long timeUsed = System.nanoTime() - startTime;
            if (stats.onFinally(timeUsed)) {
                stats.setSlowTraceId(TraceCollector.getTraceId());
            }
            if ((hasError = this.errorLocal.get()) == null) {
                hasError = Boolean.FALSE;
            }
            String node = stats.getConnection();
            TransactionCollector.collect((long)timeUsed, (boolean)hasError, (String)String.valueOf(IdentityConfigManager.getEnvId()), (String)("RabbitMq:" + node), (List)TransactionCollector.getTxName(), (String)"RabbitMqProducer");
        }
        this.statsLocal.remove();
        this.startTimeLocal.remove();
        this.errorLocal.remove();
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        if (collected != null && !collected.isEmpty()) {
            HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
            ArrayList<MonitorDataRow> totalRowList = new ArrayList<MonitorDataRow>();
            MonitorDataRow totalRow = new MonitorDataRow();
            for (MonitorDataRow row : collected) {
                RabbitMqUtils.accumulateCount(row, "invokeCount", totalRow);
                RabbitMqUtils.accumulateCount(row, "errorCount", totalRow);
                RabbitMqUtils.accumulateCount(row, "totalTime", totalRow);
                RabbitMqUtils.accumulateCount(row, "range1", totalRow);
                RabbitMqUtils.accumulateCount(row, "range2", totalRow);
                RabbitMqUtils.accumulateCount(row, "range3", totalRow);
                RabbitMqUtils.accumulateCount(row, "range4", totalRow);
                RabbitMqUtils.accumulateCount(row, "range5", totalRow);
                RabbitMqUtils.accumulateCount(row, "range6", totalRow);
                boolean isMax = RabbitMqUtils.setMax(row, "maxTime", totalRow);
                if (isMax) {
                    RabbitMqUtils.setStringValIfNull(row, "slowTraceId", totalRow);
                }
                RabbitMqUtils.setStringValIfNull(row, "errorTraceId", totalRow);
                this.doExtraCollectAfterHarvest(row, totalRow);
            }
            totalRowList.add(totalRow);
            res.put("total", totalRowList);
            return res;
        }
        return null;
    }

    protected abstract void doExtraCollectAfterHarvest(MonitorDataRow var1, MonitorDataRow var2);

    protected String primaryKey() {
        return "connection";
    }

    protected abstract Class<T> getValueType();

    public abstract String getName();
}

